function [x, flag, n_func] = optimize( op, mu, x_start )
% OPPTIMIZE optimizes  the problem op using exterior
% penalty method, penalty parameter mu and initial point
% x_start. Return values are x -- final iteration,
% flag - termination flag (> 0 if ok), n_func -- number of
% functional evaluations


%construct the penalty function first
%here we use simple quadratic penalty
obj_str = sprintf( '(%s)', op.obj_func );
grd_str = sprintf( '(%s)', op.obj_grad );
for i = 1:op.m
  obj_str = sprintf( '%s + %0.10g * (max([0,(%s)]))^2', ...
		     obj_str, mu, op.con_func{i} );
  grd_str = sprintf( '%s + %0.10g * 2*max([0,(%s)])*(%s)', ...
		     grd_str, mu, op.con_func{i}, op.con_grad{i} );  
end

opts = optimset( ...
    'GradObj', 'on', ...
    'LargeScale', 'off', ...
    'Diagnostics', 'off', ...
    'Display', 'off' ...
    );
%		 'LevenbergMarquardt', 'on', ...
%		 'MaxFunEvals', 1000000, ...
%		 'MaxIter', 100000 ...

[x, fval, flag, output] = fminunc( ...
    {inline( obj_str, 'x' ), inline( grd_str, 'x' )}, ...
    x_start, opts );

n_func = output.funcCount;

